<?php

/**
 * Helper to implementation of hook_content_default_fields().
 */
function _guestbook_content_default_fields() {
  $fields = array();

  // Exported field: field_mail
  $fields[] = array(
    'field_name' => 'field_mail',
    'type_name' => 'gb_entry',
    'display_settings' => array(
      'weight' => '-4',
      'parent' => '',
      'label' => array(
        'format' => 'hidden',
      ),
      'teaser' => array(
        'format' => 'default',
        'exclude' => 1,
      ),
      'full' => array(
        'format' => 'default',
        'exclude' => 1,
      ),
      '4' => array(
        'format' => 'default',
        'exclude' => 0,
      ),
    ),
    'widget_active' => '1',
    'type' => 'email',
    'required' => '1',
    'multiple' => '0',
    'module' => 'email',
    'active' => '1',
    'widget' => array(
      'size' => '60',
      'default_value' => array(
        '0' => array(
          'email' => '',
        ),
      ),
      'default_value_php' => NULL,
      'label' => 'Email',
      'weight' => '-4',
      'description' => '',
      'type' => 'email_textfield',
      'module' => 'email',
    ),
  );

  // Translatables
  array(
    t('Email'),
  );

  return $fields;
}

/**
 * Helper to implementation of hook_rules_defaults().
 */
function _guestbook_rules_defaults() {
  return array(
    'rules' => array(
      'guestbook_1' => array(
        '#type' => 'rule',
        '#set' => 'event_node_insert',
        '#label' => 'Notify on new guestbook content',
        '#active' => 1,
        '#weight' => '0',
        '#categories' => array(
          'guestbook' => 'guestbook',
        ),
        '#status' => 'default',
        '#conditions' => array(
          '0' => array(
            '#weight' => -10,
            '#info' => array(
              'label' => 'Created content is Guestbook entry',
              'arguments' => array(
                'node' => array(
                  'type' => 'node',
                  'label' => 'Content',
                ),
              ),
              'module' => 'Node',
            ),
            '#name' => 'rules_condition_content_is_type',
            '#settings' => array(
              'type' => array(
                'gb_entry' => 'gb_entry',
              ),
              '#argument map' => array(
                'node' => 'node',
              ),
            ),
            '#type' => 'condition',
          ),
          '1' => array(
            '#type' => 'condition',
            '#settings' => array(
              '#argument map' => array(
                'node' => 'node',
              ),
            ),
            '#name' => 'rules_condition_content_is_new',
            '#info' => array(
              'label' => 'Created content is new',
              'arguments' => array(
                'node' => array(
                  'type' => 'node',
                  'label' => 'Content',
                ),
              ),
              'module' => 'Node',
            ),
            '#weight' => -9,
          ),
        ),
        '#actions' => array(
          '0' => array(
            '#weight' => 0,
            '#info' => array(
              'label' => 'Send a mail to all moderators',
              'label callback' => FALSE,
              'module' => 'System',
              'eval input' => array(
                '0' => 'subject',
                '1' => 'message',
                '2' => 'from',
              ),
            ),
            '#name' => 'rules_action_mail_to_users_of_role',
            '#settings' => array(
              'recipients' => array(
                '0' => 3,
              ),
              'from' => '<?php print $node->field_mail[0][\'#value\']; ?>',
              'subject' => 'New guestbook entry',
              'message' => 'New guestbook entry: <?php print url(\'http://example.com/node/\' . $node->nid); ?>
',
              '#eval input' => array(
                'rules_input_evaluator_php' => array(
                  'message' => array(
                    '0' => 'node',
                  ),
                  'from' => array(
                    '0' => 'node',
                  ),
                ),
              ),
            ),
            '#type' => 'action',
          ),
        ),
        '#version' => 6003,
      ),
    ),
  );
}

/**
 * Helper to implementation of hook_user_default_permissions().
 */
function _guestbook_user_default_permissions() {
  $permissions = array();

  // Exported permission: create gb_entry content
  $permissions[] = array(
    'name' => 'create gb_entry content',
    'roles' => array(
      '0' => 'anonymous user',
      '1' => 'authenticated user',
    ),
  );

  // Exported permission: delete any gb_entry content
  $permissions[] = array(
    'name' => 'delete any gb_entry content',
    'roles' => array(
      '0' => 'moderator',
    ),
  );

  // Exported permission: edit any gb_entry content
  $permissions[] = array(
    'name' => 'edit any gb_entry content',
    'roles' => array(
      '0' => 'moderator',
    ),
  );

  return $permissions;
}
