<?php

/**
 * Implements hook_metatag_config_default().
 */
function metatag_metatag_config_default() {
  $configs = array();

  $config = new stdClass();
  $config->instance = 'global';
  $config->api_version = 1;
  $config->disabled = FALSE;
  $config->config = array(
    'title' => array('value' => '[current-page:title] | [site:name]'),
    'generator' => array('value' => 'Meta Tags by TecMaWi (http://www.tecmawi.eu) for Drupal 7 (http://drupal.org)'),
  );
  $configs[$config->instance] = $config;

  $config = new stdClass();
  $config->instance = 'global:frontpage';
  $config->api_version = 1;
  $config->disabled = FALSE;
  $config->config = array(
    'title' => array('value' => variable_get('site_slogan') ? '[site:name] | [site:slogan]' : '[site:name]'),
    'canonical' => array('value' => '[site:url]'),
  );
  $configs[$config->instance] = $config;

  $config = new stdClass();
  $config->instance = 'node';
  $config->api_version = 1;
  $config->disabled = FALSE;
  $config->config = array(
    'title' => array('value' => '[node:title] | [site:name]'),
    'description' => array('value' => '[node:summary]'),
  );
  $configs[$config->instance] = $config;

  if (module_exists('taxonomy')) {
    $config = new stdClass();
    $config->instance = 'taxonomy_term';
    $config->api_version = 1;
    $config->disabled = FALSE;
    $config->config = array(
      'title' => array('value' => '[term:name] | [site:name]'),
      'description' => array('value' => '[term:description]'),
    );
    $configs[$config->instance] = $config;
  }

  $config = new stdClass();
  $config->instance = 'user';
  $config->api_version = 1;
  $config->disabled = FALSE;
  $config->config = array(
    'title' => array('value' => '[user:name] | [site:name]'),
  );
  $configs[$config->instance] = $config;

  return $configs;
}

/**
 * Implements hook_metatag_config_instance_info().
 */
function metatag_metatag_config_instance_info() {
  $info['global']           = array('label' => t('Global'));
  $info['global:frontpage'] = array('label' => t('Front page'));
  // @todo The 403 and 404 meta tag contexts are disabled until they can be properly implemented.
  //$info['global:403']       = array('label' => t('403 page not found'));
  //$info['global:404']       = array('label' => t('404 page not found'));

  // Add instance information for entities.
  $entity_types = entity_get_info();
  foreach ($entity_types as $entity_type => $entity_info) {
    if (metatag_entity_supports_metatags($entity_type)) {
      $info[$entity_type] = array('label' => $entity_info['label']);
      foreach ($entity_info['bundles'] as $bundle => $bundle_info) {
        if (count($entity_info['bundles'] == 1) && $bundle == $entity_type) {
          // Skip default bundles (entities that do not really have bundles).
          continue;
        }
        if (metatag_entity_supports_metatags($entity_type, $bundle)) {
          $info[$entity_type . ':' . $bundle] = array('label' => $bundle_info['label']);
        }
      }
    }
  }

  return $info;
}

/**
 * Implements hook_metatag_info().
 */
function metatag_metatag_info() {
  $info['groups']['advanced'] = array(
    'label' => t('Advanced'),
    'form' => array(
      '#weight' => 90,
    ),
  );
  $info['tags']['language'] = array(
    'label' => t('Sprache'),
    'description' => t("Gebe hier die Sprache deiner Zielgruppe an. Zum Beispiel <em>de</em> f&uuml;r deutsch"),
    'class' => 'DrupalTextMetaTag'

  );
  $info['tags']['geo.region'] = array(
    'label' => t('Region'),
    'description' => t("Gebe hier an in welchem Land und welcher Region deine Seite gefunden werden soll. Zum Beispiel <em>de-sh</em> f&uuml;r Deutschland-Schleswig Holstein"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['geo.position'] = array(
    'label' => t('L&auml;ngen- und Breitengrad'),
    'description' => t("Gebe hier den L&auml;ngen- und Breitengrad deiner Zielgruppe an. Zum Beispiel <em>53.56;9.99</em> f&uuml;r Hamburg"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['icbm'] = array(
    'label' => t('L&auml;ngen- und Breitengrad icbm-Tag'),
    'description' => t("Gebe hier den L&auml;ngen- und Breitengrad deiner Zielgruppe an. Zum Beispiel <em>53.56, 9.99</em> f&uuml;r Hamburg"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['geo.placename'] = array(
    'label' => t('Stadt oder Landkreis'),
    'description' => t("Gebe hier die Stadt oder den Landkreis deiner Zielgruppe an. Zum Beispiel <em>Hamburg</em> oder <em>Stormarn</em>"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['locality'] = array(
    'label' => t('Stadtteil oder Ort'),
    'description' => t("Gebe hier den Stadtteil oder Ort deiner Zielgruppe an. Zum Beispiel <em>Hafencity</em> oder <em>Glinde</em>"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['postal-code'] = array(
    'label' => t('Postleizahl'),
    'description' => t("Gebe hier die Postleitzahl deiner Zielgruppe an. Zum Beispiel <em>21509</em>"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['description'] = array(
    'label' => t('Beschreibung'),
    'description' => t("Beschreibe hier in einem kurzen Text den Inhalt oder die Dienstleistung deiner Seite. Optimal sind 150 bis 170 Zeichen, der Rest wird bei Google abgeschnitten."),
    'class' => 'DrupalTextMetaTag',
    'form' => array(
      '#type' => 'textarea',
      '#rows' => 2,
      '#wysiwyg' => FALSE,
    ),
  );
  $info['tags']['keywords'] = array(
    'label' => t('Keywords'),
    'description' => t("Gebe hier an, unter welchen Suchbegriffen deine Seite gefunden werden soll. Zum Beispiel <em>drupal, cms, open source</em>. Diese Funktion wird zunehmend von Suchmaschinen ignoriert. F&uuml;r SEO erstelle qualitativen Content."),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['title'] = array(
    'label' => t('Title'),
    'description' => t("The text to display in the title bar of a visitor's web browser when they view this page. This meta tag may also be used as the title of the page when a visitor bookmarks or favorites this page."),
    'class' => 'DrupalTitleMetaTag',
  );
  $info['tags']['page-topic'] = array(
    'label' => t('Seitenzuordnung'),
    'description' => t("Trage hier ein, zu welchem Bereich deine Seite z&auml;hlt. Zum Beispiel <em>Dienstleistung</em>"),
    'class' => 'DrupalTextMetaTag',
  );
  $info['tags']['robots'] = array(
    'label' => t('Robots'),
    'description' => t("Teile den Suchmaschinen-Crawlern mit, was sie mit deiner Seite machen sollen."),
    'class' => 'DrupalListMetaTag',
    'form' => array(
      '#options' => array(
        'noindex' => t('Die Seite soll nicht von Suchmaschinen indexiert werden.'),
        'nofollow' => t('Die Suchmaschinen soll den Links auf der Seite nicht folgen.'),
        'noarchive' => t('Prevent a cached copy of this page from being available in the search results.'),
        'nosnippet' => t('Prevents a description from appearing below the page in the search results, as well as prevents caching of the page.'),
        'noodp' => t('Blocks the <a href="@odp-url">Open Directory Project</a> description of the page from being used in the description that appears below the page in the search results.', array('@odp-url' => 'http://www.dmoz.org/')),
      ),
    ),
    'group' => 'advanced',
  );
  $info['tags']['generator'] = array(
    'label' => t('Generator'),
    'description' => t("Describes the name and version number of the software or publishing tool used to create the page."),
    'class' => 'DrupalTextMetaTag',
    'header' => 'X-Generator',
    'context' => array('global'),
    'group' => 'advanced',
  );
  $info['tags']['copyright'] = array(
    'label' => t('Copyright'),
    'description' => t("Details a copyright, trademark, patent, or other information that pertains to intellectual property about this page. Note that this will not automatically protect your site's content or your intellectual property."),
    'class' => 'DrupalTextMetaTag',
    'group' => 'advanced',
  );

  // Link tags.
  $info['tags']['canonical'] = array(
    'label' => t('Canonical URL'),
    'description' => t("Tells search engines where the preferred location or URL is for this page to help eliminate self-created duplicate content for search engines."),
    'class' => 'DrupalLinkMetaTag',
    'group' => 'advanced',
  );
  $info['tags']['shortlink'] = array(
    'label' => t('Shortlink URL'),
    'description' => '',
    'class' => 'DrupalLinkMetaTag',
    'group' => 'advanced',
  );
  $info['tags']['publisher'] = array(
    'label' => t('Publisher URL'),
    'description' => '',
    'class' => 'DrupalLinkMetaTag',
    'group' => 'advanced',
  );

  return $info;
}