<?php
// $Id: node.tpl.php,v 1.1 2009/09/30 01:27:41 blagoj Exp $

/**
 * @file node.tpl.php
 *
 * Theme implementation to display a node.
 *
 * Available variables:
 * - $title: the (sanitized) title of the node.
 * - $content: Node body or teaser depending on $teaser flag.
 * - $picture: The authors picture of the node output from
 *   theme_user_picture().
 * - $date: Formatted creation date (use $created to reformat with
 *   format_date()).
 * - $links: Themed links like "Read more", "Add new comment", etc. output
 *   from theme_links().
 * - $name: Themed username of node author output from theme_user().
 * - $node_url: Direct url of the current node.
 * - $terms: the themed list of taxonomy term links output from theme_links().
 * - $submitted: themed submission information output from
 *   theme_node_submitted().
 *
 * Other variables:
 * - $node: Full node object. Contains data that may not be safe.
 * - $type: Node type, i.e. story, page, blog, etc.
 * - $comment_count: Number of comments attached to the node.
 * - $uid: User ID of the node author.
 * - $created: Time the node was published formatted in Unix timestamp.
 * - $zebra: Outputs either "even" or "odd". Useful for zebra striping in
 *   teaser listings.
 * - $id: Position of the node. Increments each time it's output.
 *
 * Node status variables:
 * - $teaser: Flag for the teaser state.
 * - $page: Flag for the full page state.
 * - $promote: Flag for front page promotion state.
 * - $sticky: Flags for sticky post setting.
 * - $status: Flag for published status.
 * - $comment: State of comment settings for the node.
 * - $readmore: Flags true if the teaser content of the node cannot hold the
 *   main body content.
 * - $is_front: Flags true when presented in the front page.
 * - $logged_in: Flags true when the current user is a logged-in member.
 * - $is_admin: Flags true when the current user is an administrator.
 *
 * @see template_preprocess()
 * @see template_preprocess_node()
 */

?>

<!-- start post -->
    <div class="post_odd">
     <div class="post clearfix">
       <div class="post_content_wrapper">
         <h2><a href="<?php print $node_url ?>" title="<?php print $title ?>"><?php print $title ?></a></h2>
         <div class="post_content">
           <?php print $content; ?>
         </div>
       </div>
       <dl class="post_meta">
         <dt class="meta_date"><?php print $post_year ?></dt>
         <dd class="post_date"><?php print $post_month ?><span><?php print $post_day; ?></span></dd>
         <?php if ($terms): ?>
           <dt><?php print t('TAGS') ?></dt>
           <?php print $terms; ?>
		 <?php endif; ?>
		 <?php if ($links): ?>
		   <dt class="meta_comment"><?php print $links ?></dt>
		 <?php endif; ?>
       </dl>
     </div>
    </div>

<!-- end post -->