<?php
// $Id: docs.php, v 1.0 2009/11/30 23:55:33 quiptime Exp $
/**
 * @file
 * This file contains no working PHP code; it exists to provide additional documentation
 * for doxygen as well as to document hooks in the standard Drupal manner.
 */

/**
 * @mainpage OG Forum Reloaded aka OG Forum
 *
 * @section Introduction
 * This module is the redeveloped version of <a href="http://drupal.org/project/og_forum">Paul Booker's OG Forum</a> module.
 * This module comes with the name "OG Forum Reloaded" - OGFR.
 *
 * @section Requirements
 * - Drupal 6
 *
 * Module dependencies:
 * - <a href="http://drupal.org/project/og">Organic Groups</a>
 * - Forum (Core module)
 * - <a href="http://drupal.org/project/forum_access">Forum Access</a>
 *
 * @section Installation
 *
 * Topics:
 * - @ref og_forums_installation
 *
 * @section Help
 *
 * Topics:
 * - @ref og_forums_forum_structure
 * - @ref og_forums_group_forum_container
 * - @ref og_forums_forum_quota
 * - @ref og_forums_forum_availability
 * - @ref og_forums_update_old_groups
 * - @ref og_forums_main_visibility
 * - @ref og_forums_forum_publicity
 * - @ref og_forums_access_templates
 * - @ref og_forums_troubleshooting
 * - @ref og_forums_limitations
 *
 * @section Credits
 *
 * - @ref og_forums_thanks
 */

/**
 * @page og_forums_installation Installation
 *
 * "OG Forum Reloaded" is not compatible with "OG Forum". To install OG Forum Reloaded need to uninstall the OG Forum module.
 *
 * Note:<br>
 * There are currently existing group forums of "OG Forum" can not be migrated to "OG Forum Reloaded". Such a function will come in the future.
 *
 * <h2>For a new site without Organic Groups already installed</h2>
 *
 *  1) Install/activate the Forum (core) module through the regular Drupal means.
 *
 *  2) Important: Trigger the forum vocabulary creation routine by visiting admin/forums! This is the part most often overlooked.
 *
 *  3) Install the Organic Groups module through the regular Drupal means.
 *
 *  4) Only if steps 1 and 2 were successfully: Install this module, again through the regular Drupal means.
 *
 * <h2>For a site Organic Groups already installed</h2>
 *
 *  1) Install/activate the Forum (core) module through the regular Drupal means.
 *
 *  2) Important: Trigger the forum vocabulary creation routine by visiting admin/forums! This is the part most often overlooked.
 *
 *  3) Only if steps 1 and 2 were successfully: Install this module, again through the regular Drupal means.
 *
 *  4) Go to admin/og/og_forums and click on "Update old groups" to have forum containers
 *  and default forums created for existing groups. See the help section for options.
 */

/**
 * @page og_forums_forum_structure Administer Forum structure
 *
 * Here you can define a pre-configured structure for creating new group forums. It can be used a simple or multiple structure.
 *
 * When a new group ist created.
 *
 * <h2>Options</h2>
 *
 * @li Default forum structure<br>
 *     When a new group is created then the structure defined here is used. Note: But this will only be realized if the option Same container is activated.
 *
 * @li Same container<br>
 *     The name of the container matches the name of the group.
 *
 * <h3>Default forum structure</h3>
 *
 * To use the Default forum structure, change the default forum name/s to a semicolon seperated entry.
 *
 * Use C for new container, P for the previous container, R to return to the root container.
 *
 * <h3>Structure examples</h3>
 *
 * Forum 1;C;Container 2;Forum 2;C;Container 3;Forum 3;R;Forum 4
 * @code
 * - Group name container
 * -- Forum 1
 * -- Container 2
 * --- Forum 2
 * --- Container 3
 * ---- Forum 3
 * -- Forum 4
 * @endcode
 *
 * Forum General discussion;Forum Other;C;Container More;Forum Whats up;R;C;Container Extra;Forum Help
 * @code
 * - Group name container
 * -- Forum General discussion
 * -- Forum Other
 * -- Container More
 * --- Forum Whats up
 * -- Container Extra
 * --- Forum Help
 * @endcode
 *
 * To use descriptions. Follow the container or forum name by a comma, then description.
 *
 * E.g. Forum 3,This is a description;Forum 4
 *
 * <h3>Structure depth</h3>
 *
 * Correctly supported depth for container is 2.
 * @code
 * - Group name container
 * -- Container
 * --- Container
 * @endcode
 *
 * A greater depth is possible. But there create confused forum lists and confuses the user.
 *
 * The best is: Keep it simple and straightforward.
 *
 * <h2>Group manager</h2>
 *
 * Group manager can only manage forums - no container.
 *
 * <h2>Displaying groups forums</h2>
 *
 * In the forum lists, not the administration, are not displayed empty containers.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_group_forum_container Administer Group forum container
 *
 * <h2>Options</h2>
 *
 * @li Default container<br>
 *     All group forums will be placed in a common container - or not. You need to have setup the container before hand.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_forum_quota Administer Forum quota
 *
 * Limit number of forums per group.
 *
 * <h2>Options</h2>
 *
 * @li Quota<br>
 *   Set the number of forums a group can have. When forums are defined in the Default forum structure field, then their number must be calculated here.
 * @li Display quota message<br>
 *   If the number of group forums is limited, a group manager receives a message when the limit is reached. This message is displayed in the management of the forums of the group.
 * @li Display add forum Link<br>
 *   If not reached the quota limit is displayed a add forum link. This link is displayed in the management of the forums of the group.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_forum_availability Administer Forum availability
 *
 * The forum function is available by default in each group. Here you can allow the group managers to disable or enable this function for their groups.
 *
 * If the availability is off the existing forums will not be deleted - they are no longer reachable.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_update_old_groups Administer Retroactively update old groups
 *
 * This function will create forums for any groups that do not already have them.
 *
 * This is a single button which adds containers and forums to each existing OG and is
 * to be used if you install OGFR into a site where groups already exist. You may
 * wish to change some settings below before pushing this button.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_main_visibility Administer Main visibility
 *
 * Visibility of the OG Forums in the main forum list.
 *
 * <h2>Options</h2>
 *
 * @li No, not visible in the main list.
 * @li Yes, visible in the main list.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_forum_publicity Administer Forum publicity
 *
 * <h2>Options</h2>
 *
 * <h3>Automatic forum publicity</h3>
 *
 * This turns on/off the automatic publicity of group forums. If a group forum has at
 * least one post which is public, than entries will be made in the database to indicate
 * that the forum and its container are also publicly browsable. If a group forum does
 * not have any public posts, then that forum will not be publicly browsable except as
 * noted below in conjunction with other settings.
 *
 * <h3>Allow public choice</h3>
 *
 * This allows group owners to decide which of their forums are public or private, but
 * can also work with the auto setting above. First an explaination without the auto
 * setting:
 *
 * In each forum, the group owner (or admins) will see a link in the context menu to
 * 'Administer group forums' which presents a table structure whereby they may edit
 * forums' names or delete them, add forums to the container, make them public,
 * make them private or reset them.
 *
 * With the auto setting:
 *
 * Forums and containers will appear or not in any browsable listing per the standard
 * automatic rules unless overridden by the group owner or an admin. As mentioned above,
 * the 'set by owner' values take precedence over the 'auto' and 'default' values when
 * determining publicity or browsability.
 *
 * <h3>Make all forums public</h3>
 *
 * Checking this does not mean you can't check the options above. However, the effects of
 * any settings made under the above settings will not be appearant unless this feature
 * is later turned off. This is either an easy way to ensure that all forums are always
 * browsable by the public, or may be used to temporarily open the site for something like
 * an 'open house'. Turning it off would keep in-tact any settings made before its use.
 *
 * <h3>Manage publicity of old groups</h3>
 *
 * Similar to the other retroactive control above, this one manages publicity settings in
 * the database for the case where you are upgrading from a version of og_forum without
 * these features. As noted on the admin page, it should only be used once.
 *
 * <h3>Switch to automatic publicity</h3>
 *
 * Although this may sound like simply turning off the 'Make all forums public' check box
 * and ensuring that the 'Automatic forum publicity' checkbox is set, that is NOT what
 * this feature does.
 *
 * Should you use the 'Allow public choice' feature, but later decide that as site admin
 * you would like total control of the forums' publicity, you may push this button and
 * change all entries in the database to reflect a state as though they had always been
 * managed by the 'Automatic forum publicity' feature.
 *
 * Make sure that you uncheck the 'Allow public choice' checkbox, or else group owners will
 * continue to be able to make their own settings.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_access_templates Administer Access templates
 *
 * You can use the access templates as defaults for new group forums and group containers. The templates are used when a user create a group or when a group manager create forums.
 *
 * It is recommended to use this functionality.
 *
 * The "Forum Access" module does not work when creating groups or group forums.
 *
 * Note:
 *
 * Anonymous user do not need permissions.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_troubleshooting Troubleshooting
 *
 * <h2>Errors</h2>
 *
 * <h3>Log entries</h3>
 *
 * - "It has created a groups node and it was used a term ID 0. The term has ..."<br>
 * Delete double or triple content. Delete database entries with the term ID 0.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_limitations Known Limitations
 *
 * The Opera browser can not be used.
 *
 * If this browser adds new groups, there are mistakes: Group nodes are created double or triple. In consequence of which the terms of the taxonomy created will be double or triple.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */

/**
 * @page og_forums_thanks Thanks
 *
 * Thanks to:
 *
 * - Ryan Constantine (Drupal ID rconstantine) & Paul Booker (Drupal ID paulbooker), the current maintainers of the OG Forum module.
 *
 * - Darren Oh (Drupal ID Darren Oh), a previous maintainer of the OG Forum module.
 *
 * - Josh Cohen (Drupal ID joshua_cohen) for the integration of multiple forum code change in the OG Forum module.
 *
 * - Evan Leeson (Drupal ID lectric) of Catalyst Creative for sponsorship of 4.7 port and improvements.
 *
 * - Gavin Mogan (Drupal ID halkeye) for http://drupal.org/node/63379 which was a huge help in porting the OG Forum module.
 *
 * <a href="#" onclick="history.go(-1); return false;">Back</a>
 */
