<?php
// $Id: og_forums.admin.inc, v 1.0 2009/12/08 15:12:02 quiptime Exp $

/**
 * @file
 * Function file to administer the OG Forums Reloded module.
 */

/**
 * Create the admin settings form.
 *
 * @see og_forums_settings_submit()
 * @see og_forums_admin_settings_validate()
 */
function og_forums_admin_settings() {
  drupal_add_css(drupal_get_path('module', 'og_forums') .'/og_forums.admin.css');

  // Forum structure.
  $description_structure = '<p>'. t('Here you can define a pre-configured structure for creating new groups forums.') .'</p>';
  $description_structure .= '<p>'. t('It can be used a simple or multiple structure. More information can be found in the module help.') .'</p>';
  $form['structure'] = array(
    '#type' => 'fieldset',
    '#title' => t('Forum structure'),
    '#description' => $description_structure,
    '#collapsible' => TRUE,
  );
  $current_default_name = t('General discussion;Other');
  $form['structure']['og_forums_default_name'] = array(
    '#type' => 'textfield',
    '#title' => t('Default forum structure'),
    '#description' => t('When a new group is created then the structure defined here is used. Note: But this will only be realized if the option <em>Same container</em> is activated.'),
    '#default_value' => variable_get('og_forums_default_name', $current_default_name),
    '#required' => TRUE,
  );
  $form['structure']['og_forums_default_container_yn'] = array(
    '#type' => 'checkbox',
    '#title' => t('Same container'),
    '#description' => t('The name of the container matches the name of the group. If you would like groups forums structures to all be under one container?'),
    '#default_value' => variable_get('og_forums_default_container_yn', TRUE),
  );

  // Default container.
  $form['container'] = array(
    '#type' => 'fieldset',
    '#title' => t('Groups forums container'),
    '#collapsible' => TRUE,
  );

  $forum_containers = variable_get('forum_containers', array());

  $sql = "SELECT tid, name FROM {term_data} WHERE tid NOT IN (SELECT tid FROM {og_terms})";
  $result = db_query($sql);

  $containers = array();
  $containers[-1] = t('No one');
  while ($term = db_fetch_object($result)) {
    if (in_array($term->tid, $forum_containers)) {
      $containers[$term->tid] = check_plain($term->name);
    }
  }

  $form['container']['og_forums_default_container'] = array(
    '#type' => 'select',
    '#title' => t('Default container'),
    '#description' => t('All groups forums will be placed in a common container. You need to have setup the container before hand.'),
    '#default_value' => variable_get('og_forums_default_container', 0),
    '#options' => $containers,
  );

  // Forum quota.
  $form['quota'] = array(
    '#type' => 'fieldset',
    '#title' => t('Forum quota'),
    '#description' => t('Limit number of forums per group.'),
    '#collapsible' => TRUE,
  );
  $form['quota']['og_forums_limit_forums'] = array(
    '#type' => 'select',
    '#title' => t('Quota'),
    '#description' => t('Set the number of forums a group can have. When forums are defined in the %structure field, then their number must be calculated here.', array('%structure' => t('Default forum structure'))),
    '#options' => _og_forums_quota(),
    '#default_value' => variable_get('og_forums_limit_forums', 7),
  );
  $form['quota']['og_forums_quota_message'] = array(
    '#type' => 'checkbox',
    '#title' => t('Display quota message'),
    '#description' => t('If the number of groups forums is limited, a group manager receives a message when the limit is reached. This message is displayed in the management of the forums of the group.'),
    '#default_value' => variable_get('og_forums_quota_message', 1),
  );
  $form['quota']['og_forums_add_link'] = array(
    '#type' => 'checkbox',
    '#title' => t('Display %link link', array('%link' => t('add forum'))),
    '#description' => t('If not reached the quota limit is displayed a %link link. This link is displayed in the management of the forums of the group.', array('%link' => t('add forum'))),
    '#default_value' => variable_get('og_forums_add_link', 1),
  );

  // Availability forum function.
  $form['availability'] = array(
    '#type' => 'fieldset',
    '#title' => t('Forum availability'),
    '#description' => ('The forum function is available by default in each group. Here you can allow the group managers to disable or enable this function for their groups.'),
    '#collapsible' => TRUE,
  );
  $form['availability']['og_forums_availability_grant'] = array(
    '#type' => 'checkbox',
    '#title' => t('Availability permission'),
    '#description' => t('Permission for group managers to disable the the forums function.'),
    '#default_value' => variable_get('og_forums_availability_grant', 1),
  );

  // Update old groups.
  $form['update'] = array(
    '#type' => 'fieldset',
    '#title' => t('Retroactively update old groups'),
    '#description' => t('Pressing this button will create forums for any groups that do not already have them.'),
    '#collapsible' => TRUE,
  );
  $form['update']['button'] = array(
    '#type' => 'submit',
    '#name' => 'update_old_groups',
    '#value' => t('Update old groups'),
  );

  // Main visibility.
  $form['main_visibility'] = array(
    '#type' => 'fieldset',
    '#title' => t('Main visibility'),
    '#description' => t('Visibility of the OG Forums in the main forum list.'),
    '#collapsible' => TRUE,
  );
  $form['main_visibility']['og_forums_main_visibility'] = array(
    '#type' => 'select',
    '#description' => t('Please choose the visibility.'),
    '#options' => array(
      0 => t('No, not visible in the main list.'),
      1 => t('Yes, visible in the main list.'),
    ),
    '#default_value' => variable_get('og_forums_main_visibility', 0),
  );

  // Forum publicity administration.
  $form['public_forums'] = array(
    '#type' => 'fieldset',
    '#title' => t('Forum publicity'),
    '#description' => t('Using these features is probably expensive in terms of SQL queries.'),
    '#collapsible' => TRUE,
  );
  $form['public_forums']['og_forums_auto_public'] = array(
    '#type' => 'checkbox',
    '#title' => t('Automatic forum publicity'),
    '#description' => t('If you would like to make the publicity, or public-ness, of forums automatic based on whether there are any public posts inside
    of them, then check this box.'),
    '#default_value' => variable_get('og_forums_auto_public', 0),
  );
  $form['public_forums']['og_forums_allow_public'] = array(
    '#type' => 'checkbox',
    '#title' => t('Allow public choice'),
    '#description' => t('If you would like to allow group owners the ability to decide which, if any, of their forums are publicly viewable, check the box.
    Those with the <em>make forums public</em> permission can always make forums and containers public. If auto mode is checked, above, then this will
    allow group owners to override auto settings on a case by case basis. The auto mode respects group owner-set values.'),
    '#default_value' => variable_get('og_forums_allow_public', 0),
  );
  $form['public_forums']['og_forums_all_public'] = array(
    '#type' => 'checkbox',
    '#title' => t('Make all forums public'),
    '#description' => t('This is only a display option and will not affect database entries. If you have both boxes unchecked above and no users assigned
    to the <em>make forums public</em> permission, no database entries will be made as to the publicity of forums, but all will be visible and traversable.
    User 1 can still affect the database through the normal "make public" and "make private" functionality, but such changes won\'t affect the forums\'
    display until such time as this feature is disabled. Individual posts will be public or private based on their own settings, just like if the above
    features are used. This is an easy way to get all forums visible to all users so they can see what posts they are missing out on (in the case where posts
    are private themselves). With this setting, no forums can be private. You could use this feature during a promotion period to temporarily open the whole
    site to guests.'),
    '#default_value' => variable_get('og_forums_all_public', 0),
  );
  $form['public_forums']['pb'] = array(
    '#type' => 'fieldset',
    '#title' => t('Manage publicity of old groups'),
    '#description' => t('If you check the "Automatic forum publicity" box, this will go through all existing forums and set them accordingly.
    Otherwise, a public forum topic will need to be created or resaved in each forum. You don\'t need to click this if you haven\'t checked that box.
    <strong>You should use this only once - usually the first time you upgrade to a version with this feature as it will not respect settings made by
    group owners.</strong>'),
  );
  $form['public_forums']['pb']['public_button'] = array(
    '#type' => 'submit',
    '#name' => 'public_button',
    '#value' => t('Publicize old groups'),
  );
  $form['public_forums']['rp'] = array(
    '#type' => 'fieldset',
    '#title' => t('Switch to automatic publicity'),
    '#description' => t('This will switch all group admin-set publicity values to automatic values. PUBLIC_BY_GROUP_OWNER -> PUBLIC_AUTO, PRIVATE_BY_GROUP_OWNER -> PRIVATE_DEFAULT. This will allow you to switch a site from
    group admin-controlled publicity to automatic publicity of forums.'),
  );
  $form['public_forums']['rp']['switch_auto'] = array(
    '#type' => 'submit',
    '#name' => 'switch_auto',
    '#value' => t('Switch to auto mode'),
  );

  // Access templates.
  $form['template']['og_forums_access'] = array(
    '#type' => 'fieldset',
    '#title' => t('Access templates'),
    '#description' => t('You can use the access templates as defaults for new groups forums and group containers. The templates are used when the group manager create forums. It is recommended to use this functionality.'),
    '#collapsible' => TRUE,
    '#suffix' => '<div style="text-align: right;">'. t('Module Development by') .' '. l('Quiptime Group', 'http://www.quiptime.com', array('attributes' => array('target' => '_blank'))) . '</div>',
  );
  $form['template']['og_forums_access']['og_forums_access_template'] = array(
    '#type' => 'checkbox',
    '#title' => t('Use access templates'),
    '#description' => '',
    '#default_value' => variable_get('og_forums_access_template', 1),
  );
  $form['template']['og_forums_access']['container'] = array(
    '#type' => 'fieldset',
    '#title' => t('Container'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  _og_forums_access_template_form(&$form, &$form_state, 'container');

  $form['template']['og_forums_access']['forum'] = array(
    '#type' => 'fieldset',
    '#title' => t('Forum'),
    '#collapsible' => TRUE,
    '#collapsed' => TRUE,
  );
  _og_forums_access_template_form(&$form, &$form_state, 'forum');

  $form['#submit'][] = 'og_forums_settings_submit';

  return system_settings_form($form);
}

/**
 * Admin settings form validation callback.
 *
 * @see og_forums_admin_settings()
 */
function og_forums_admin_settings_validate($form, &$form_state) {
  $not_saved = t('The configuration options were not saved.');

  // Check minimum 1 forum name.
  if (strlen($form_state['values']['og_forums_default_name']) == 0) {
    drupal_set_message($not_saved, 'error');
    $names_error = t('There is no forum for the groups in the %structure. Please enter at least 1 name for a forum.', array('%structure' => t('Forum structure')));
    form_set_error('og_forums_default_name', $names_error);
  }

  // Compare the number of forums with the quota.
  if (strlen($form_state['values']['og_forums_default_name']) >= 1 && $form_state['values']['og_forums_default_container_yn'] == 1) {
    $default_name = _og_forums_clean_forum_names($form_state['values']['og_forums_default_name']);
    $forum_names = explode(';', $default_name);

    // Determine the number of defined forums.
    $count = 0;
    foreach ($forum_names as $key => $name) {
      $count++;
      if (strtoupper($name) == 'C') {
        $count--;
        $count--;
      }
      elseif (strtoupper($name) == 'R' || strtoupper($name) == 'P') {
        $count--;
      }
    }

    if ($form_state['values']['og_forums_limit_forums'] > 0 && $form_state['values']['og_forums_limit_forums'] < $count) {
      drupal_set_message($not_saved, 'error');
      $names_error = t('The <em>Forum quota</em> of <strong>!quota</strong> is smaller than the number of <strong>!names</strong> forums in the <em>Forum structure</em>. Please increase the quota or reduce the number of forums.', array('!quota' => $form_state['values']['og_forums_limit_forums'], '!names' => $count));
      form_set_error('og_forums_default_name', $names_error);
    }
  }
}

/**
 * Submit handler for group update.
 *
 * @see og_forums_admin_settings()
 */
function og_forums_settings_submit($form, &$form_state) {
  if ($form_state['clicked_button']['#name'] == 'update_old_groups') {
    og_forums_retroactively_apply();
  }
  elseif ($form_state['clicked_button']['#name'] == 'public_button') {
    $auto_public = variable_get('og_forums_auto_public', 0);
    if ($auto_public) {
      // Go through all existing forums and where a node has been made public, set the forum's publicity to PUBLIC_AUTO.
      $sql = "SELECT DISTINCT tn.tid, oa.group_nid FROM {node} n
              INNER JOIN {og_ancestry} oa ON oa.nid = n.nid
              INNER JOIN {og_access_post} oap ON oap.nid = oa.nid
              INNER JOIN {term_node} tn ON tn.nid = oa.nid
              WHERE n.type = 'forum' AND oap.og_public = 1";
      $results = db_query($sql);

      while ($result = db_fetch_object($results)) {
        $gid = $result->group_nid;
        $container = og_forums_get_forum_container($gid);
        $sql2 = "UPDATE {og_terms} SET public = %d WHERE tid = %d and nid = %d";
        db_query($sql2, PUBLIC_AUTO, $result->tid, $gid);
        db_query($sql2, PUBLIC_AUTO, $container, $gid);
      }
    }
    else {
      drupal_set_message(t('You need to select "Automatic forum publicity" for this to work.'), 'error');
    }
  }
  elseif ($form_state['clicked_button']['#name'] == 'switch_auto') {
    $sql = "UPDATE {og_terms} SET public = %d WHERE public = %d";
    db_query($sql, PUBLIC_AUTO, PUBLIC_BY_GROUP_OWNER);
    db_query($sql, PRIVATE_DEFAULT, PRIVATE_BY_GROUP_OWNER);
  }

  if ($form_state['clicked_button']['#id'] == 'edit-submit') {
    variable_set('og_forums_default_name', $form_state['values']['og_forums_default_name']);
    variable_set('og_forums_default_container_yn', $form_state['values']['og_forums_default_container_yn']);
    variable_set('og_forums_default_container', $form_state['values']['og_forums_default_container']);
    variable_set('og_forums_allow_public', $form_state['values']['og_forums_allow_public']);
    variable_set('og_forums_auto_public', $form_state['values']['og_forums_auto_public']);
    variable_set('og_forums_all_public', $form_state['values']['og_forums_all_public']);
    variable_set('og_forums_limit_forums', $form_state['values']['og_forums_limit_forums']);

    // Access templates.
    $access_template_container = array(
      DRUPAL_AUTHENTICATED_RID => array(
        'grant_view' => $form_state['values']['container-view'],
        'grant_create' => $form_state['values']['container-create'],
        'priority' => 0,
      ),
    );
    $access_template_forum = array(
      DRUPAL_ANONYMOUS_RID => array(
        'grant_view' => 0,
        'grant_update' => 0,
        'grant_delete' => 0,
        'grant_create' => 0,
        'priority' => 0,
      ),
      DRUPAL_AUTHENTICATED_RID => array(
        'grant_view' => $form_state['values']['forum-view'],
        'grant_update' => $form_state['values']['forum-update'],
        'grant_delete' => $form_state['values']['forum-delete'],
        'grant_create' => $form_state['values']['forum-create'],
        'priority' => 0,
      ),
    );
    variable_set('og_forums_access_template_container', $access_template_container);
    variable_set('og_forums_access_template_forum', $access_template_forum);
  }
}

/**
 * Helper function to create access template form elements.
 *
 * @see og_forums_admin_settings()
 */
function _og_forums_access_template_form(&$form, &$form_state, $op) {
  $tpl_settings_container = variable_get('og_forums_access_template_container', _og_forums_access_template_container_default());
  $tpl_settings_forum = variable_get('og_forums_access_template_forum', _og_forums_access_template_forum_default());

  $roles = array();
  $result = db_query(db_rewrite_sql("SELECT r.rid, r.name FROM {role} r WHERE rid = ". DRUPAL_AUTHENTICATED_RID ." ORDER BY r.name", 'r', 'rid'));
  while ($obj = db_fetch_object($result)) {
    $roles[$obj->rid] = check_plain($obj->name);
  }

  if ($op == 'container') {
    $is_container = TRUE;
  }

  // Column titles.
/*
  $form['template']['og_forums_access'][$op]['headers'][$op .'-view'] = array(
    '#type' => 'item',
    '#prefix' => '<div class="forum-access-div">',
    '#title' => ($is_container ? t('View this container') : t('View this forum')),
    '#suffix' => '</div>',
  );
*/
  $forum_vocabulary = taxonomy_vocabulary_load(variable_get('forum_nav_vocabulary', ''));
  $form['template']['og_forums_access'][$op]['headers'][$op .'-create'] = array(
    '#type' => 'item',
    '#prefix' => '<div class="forum-access-div">',
    '#title' => t('See this container in the %Forums selection list', array('%Forums' => $forum_vocabulary->name)),
    '#suffix' => '</div>',
  );

  if (!$is_container) {
    $form['template']['og_forums_access'][$op]['headers'][$op .'-create'] = array(  // overwrite!
      '#type' => 'item',
      '#prefix' => '<div class="forum-access-div">',
      '#title' => t('Post in this forum'),
      '#suffix' => '</div>',
    );

    $form['template']['og_forums_access'][$op]['headers'][$op .'-update'] = array(
      '#type' => 'item',
      '#prefix' => '<div class="forum-access-div">',
      '#title' => t('Edit posts'),
      '#suffix' => '</div>',
    );
    $form['template']['og_forums_access'][$op]['headers'][$op .'-delete'] = array(
      '#type' => 'item',
      '#prefix' => '<div class="forum-access-div">',
      '#title' => t('Delete posts'),
      '#suffix' => '</div>',
    );
  }
  $form['template']['og_forums_access'][$op]['headers']['clearer'] = array(
    '#value' => '<div class="forum-access-clearer"></div>',
  );

  // Column content (checkboxes).
  if ($is_container) {
    $form['template']['og_forums_access'][$op][$op .'-view'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_view'),
    );
    $form['template']['og_forums_access'][$op][$op .'-create'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_create'),
    );
  }

  if (!$is_container) {
    $form['template']['og_forums_access'][$op][$op .'-view'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_view'),
    );
    $form['template']['og_forums_access'][$op][$op .'-create'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_create'),
    );
    $form['template']['og_forums_access'][$op][$op .'-update'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_update'),
    );
    $form['template']['og_forums_access'][$op][$op .'-delete'] = array(
      '#type' => 'checkbox',
      '#title' => $roles[DRUPAL_AUTHENTICATED_RID],
      '#prefix' => '<div class="forum-access-div">',
      '#suffix' => '</div>',
      '#default_value' => _og_forums_template_value($op, 'grant_delete'),
    );
  }

  drupal_add_css(drupal_get_path('module', 'forum_access') .'/forum_access.css');
}

/**
 * Helper function to build default values for access templates.
 *
 * @see _og_forums_access_template_form()
 */
function _og_forums_template_value($op, $param) {
  $tpl_settings_container = variable_get('og_forums_access_template_container', _og_forums_access_template_container_default());
  $tpl_settings_forum = variable_get('og_forums_access_template_forum', _og_forums_access_template_forum_default());

  if ($op == 'forum') {
    $value[$param] = $tpl_settings_forum[DRUPAL_AUTHENTICATED_RID][$param] ? isset($tpl_settings_forum[DRUPAL_AUTHENTICATED_RID][$param]) : 0;
  }
  elseif ($op == 'container') {
    $value[$param] = $tpl_settings_container[DRUPAL_AUTHENTICATED_RID][$param] ? isset($tpl_settings_forum[DRUPAL_AUTHENTICATED_RID][$param]) : 0;
  }

  return $value[$param];
}

/**
 * Helper function to build an option list for forum quota.
 *
 * @see og_forums_admin_settings()
 */
function _og_forums_quota() {
  $numbers = array(0 => t('No limitation')) + drupal_map_assoc(array(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 30, 35, 40, 45, 50));
  return $numbers;
}
